//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Collections;
using System.Security.Principal;
using System.Security.Policy;
using System.Net;
using System.IO;
using System.Diagnostics;
using TOKDUMPSRVLib;

enum RID
{
	// Znane take jako World, Null, Creator/Owner, i Group
	SECURITY_NULL_RID				= 0x00000000,
	SECURITY_DIALUP_RID             = 0x00000001,
	SECURITY_NETWORK_RID            = 0x00000002,
	SECURITY_BATCH_RID              = 0x00000003,
	SECURITY_INTERACTIVE_RID        = 0x00000004,
	SECURITY_LOGON_IDS_RID          = 0x00000005,
	SECURITY_SERVICE_RID            = 0x00000006,
	SECURITY_ANONYMOUS_LOGON_RID    = 0x00000007,
	SECURITY_PROXY_RID              = 0x00000008,
	SECURITY_SERVER_LOGON_RID		= 0x00000009,
	SECURITY_PRINCIPAL_SELF_RID     = 0x0000000A,
	SECURITY_AUTHENTICATED_USER_RID = 0x0000000B,
	SECURITY_RESTRICTED_CODE_RID    = 0x0000000C,
	SECURITY_TERMINAL_SERVER_RID    = 0x0000000D,
	SECURITY_REMOTE_LOGON_RID       = 0x0000000E,
	SECURITY_LOCAL_SYSTEM_RID       = 0x00000012,
	SECURITY_LOCAL_SERVICE_RID      = 0x00000013,
	SECURITY_NETWORK_SERVICE_RID    = 0x00000014,
	SECURITY_NT_NON_UNIQUE          = 0x00000015,
	SECURITY_BUILTIN_DOMAIN_RID     = 0x00000020,
	DOMAIN_USER_RID_ADMIN			= 0x000001F4,
	DOMAIN_USER_RID_GUEST			= 0x000001F5,
	DOMAIN_USER_RID_KRBTGT			= 0x000001F6,
	DOMAIN_GROUP_RID_ADMINS			= 0x00000200,
	DOMAIN_GROUP_RID_USERS			= 0x00000201,
	DOMAIN_GROUP_RID_GUESTS			= 0x00000202,
	DOMAIN_GROUP_RID_COMPUTERS		= 0x00000203,
	DOMAIN_GROUP_RID_CONTROLLERS	= 0x00000204,
	DOMAIN_GROUP_RID_CERT_ADMINS	= 0x00000205,
	DOMAIN_GROUP_RID_SCHEMA_ADMINS	= 0x00000206,
	DOMAIN_GROUP_RID_ENTERPRISE_ADMINS = 0x00000207,
	DOMAIN_GROUP_RID_POLICY_ADMINS	= 0x00000208,
	DOMAIN_ALIAS_RID_ADMINS			= 0x00000220,
	DOMAIN_ALIAS_RID_USERS			= 0x00000221,
	DOMAIN_ALIAS_RID_GUESTS			= 0x00000222,
	DOMAIN_ALIAS_RID_POWER_USERS	= 0x00000223,
	DOMAIN_ALIAS_RID_ACCOUNT_OPS	= 0x00000224,
	DOMAIN_ALIAS_RID_SYSTEM_OPS		= 0x00000225,
	DOMAIN_ALIAS_RID_PRINT_OPS		= 0x00000226,
	DOMAIN_ALIAS_RID_BACKUP_OPS		= 0x00000227,

	DOMAIN_ALIAS_RID_REPLICATOR		= 0x00000228,
	DOMAIN_ALIAS_RID_RAS_SERVERS	= 0x00000229,
	DOMAIN_ALIAS_RID_PREW2KCOMPACCESS = 0x0000022A,
	DOMAIN_ALIAS_RID_REMOTE_DESKTOP_USERS = 0x0000022B,
	DOMAIN_ALIAS_RID_NETWORK_CONFIGURATION_OPS = 0x0000022C
}

namespace Principal
{
	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>
	class PrincipalDisplay
	{
		static void Main(string[] args)
		{
			WindowsIdentity wi = WindowsIdentity.GetCurrent();
			WindowsPrincipal wp = new WindowsPrincipal(wi);
			Console.WriteLine("My name is: {0}", wi.Name);
			Console.WriteLine("Authentication type: {0}", wi.AuthenticationType);
			Console.WriteLine("Anonymous: {0}", wi.IsAnonymous);
			Console.WriteLine("Authenticated: {0}", wi.IsAuthenticated);
			Console.WriteLine("Guest: {0}", wi.IsGuest);
			Console.WriteLine("System: {0}", wi.IsSystem);

			Console.WriteLine("Mj eton to: {0}", wi.Token);
			// Zrzut informacji o etonie
			ITokDump2 itd = new TokDumpClass();
			StreamWriter file = new StreamWriter("tokendump.htm");
			file.Write(itd.DumpThisToken((int)wi.Token, 0x177));
			file.Close();
			// Wywietlenie informacji o etonie
			Process.Start("tokendump.htm");

			// Ptla dla niektrych wartoci WindowsBuiltInRole.
			foreach(int i in Enum.GetValues(typeof(WindowsBuiltInRole)))
			{
				try
				{
					Console.WriteLine("{0}: {1}",
						Enum.GetName(typeof(WindowsBuiltInRole), i),
						wp.IsInRole((WindowsBuiltInRole)i));
				}
				catch(Exception)
				{
					Console.WriteLine("Uzyskanie RID dla {0} nie jest moliwe",
						Enum.GetName(typeof(WindowsBuiltInRole), i));
				}
			}

			Console.WriteLine("Uytkownicy debuggera: {0}", wp.IsInRole(Dns.GetHostName() + "\\Debugger Users"));

			// Ptla dla niektrych wartoci RID w the Platform SDK.
			foreach(int i in Enum.GetValues(typeof(RID)))
			{
				try
				{
					Console.WriteLine("{0}: {1}",
						Enum.GetName(typeof(RID), i),
						wp.IsInRole(i));
				}
				catch(Exception)
				{
					Console.WriteLine("Uzyskanie RID dla {0} nie jest moliwe",
						Enum.GetName(typeof(RID), i));
				}
			}
		}
	}
}
